<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\CategoryImage;
use bitcream\gmvricambi\custom\backend\models\CategoryImageSearch;
use bitcream\gmvricambi\custom\backend\models\GMVArticlesCategory;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * CategoryImageController implements the CRUD actions for CategoryImage model.
 */
class CategoryImageController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all CategoryImage models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CategoryImageSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single CategoryImage model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new CategoryImage model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($articleCategory)
    {
        $model = new CategoryImage();
        $cover_image = "";

        if ($model->load(Yii::$app->request->post())) {
            if($model->cover_image){
                $model->image = Yii::$app->params['serverName'].$model->cover_image[1]->href;        
                $model->category_id = $articleCategory;
                $model->image_id = $model->cover_image[1]->id;
            }
            $model->save(false);

            return $this->redirect(['gmv-articles-category/index']);
        }

        return $this->render('create', [
            'model' => $model,
            'cover_image' => $cover_image,
        ]);
    }

    /**
     * Updates an existing CategoryImage model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $articleCategory)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            if($model->cover_image){
                $cover_image = $model->cover_image[1];
                $model->image = Yii::$app->params['serverName'].$model->cover_image[1]->href;   
                $model->category_id = $articleCategory;
                $model->image_id = $model->cover_image[1]->id;             
            }
            $model->save(false);
            
            return $this->redirect(['gmv-articles-category/index']);
        }else{
            $cover_image = $model->cover_image;
        }
    
        return $this->render('update', [
            'model' => $model,
            'cover_image' => $cover_image,
        ]);
    }

    /**
     * Deletes an existing CategoryImage model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['gmv-articles-category/index']);
    }

    /**
     * Finds the CategoryImage model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return CategoryImage the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = CategoryImage::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
