<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVSparePartsForOrder;

/**
 * GMVSparePartsForOrderSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVSparePartsForOrder`.
 */
class GMVSparePartsForOrderSearch extends GMVSparePartsForOrder
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['plant_cod', 'plant_reference', 'order_reference', 'article_cod', 'description'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVSparePartsForOrder::find()->limit(50);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        foreach($params as $key => $value){
            // grid filtering conditions
            $query->andFilterWhere([
                $key => $value,
            ]);
        }

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere(['like', 'plant_cod', $this->plant_cod])
            ->andFilterWhere(['like', 'plant_reference', $this->plant_reference])
            ->andFilterWhere(['like', 'order_reference', $this->order_reference])
            ->andFilterWhere(['like', 'article_cod', $this->article_cod])
            ->andFilterWhere(['like', 'description', $this->description]);

        return $dataProvider;
    }
}
