<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\Order;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

/**
 * OrderCustomerSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\Order`.
 */
class OrderCustomerSearch extends Order
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'postal_code', 'status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['name', 'slug', 'order_date', 'business_name', 'address', 'locality', 'province', 'country', 'delivery_date', 'payment_method', 'payment_information', 'order_status', 'created_at', 'updated_at', 'customer_cod', 'GMV_PK_Insert_Date', 'GMV_PK', 'shipping_address'], 'safe'],
            [['total'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Order::find();
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'postal_code' => $this->postal_code,
            'total' => $this->total,
            'status' => $this->status,
            'created_user_id' => $this->created_user_id,
            'updated_user_id' => $this->updated_user_id,
        ]);

        if($customerUser->destinationSelected != "all"){
            $query->andFilterWhere(
                ['=', 'locality', $customerUser->destinationSelected]
            );
        }

        if(isset($customerUser->startDateSelected)){
            $query->andFilterWhere(
                ['between', 'order_date', $customerUser->startDateSelected, $customerUser->endDateSelected]
            );
        }       

        $query->andFilterWhere(
            ['=', 'customer_cod', $customerUser->customerCod]
        );
        
        $query = $this->orderStatusQueryFilter($query);
        

        $query->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'slug', $this->slug])
            ->andFilterWhere(['like', 'order_date', $this->order_date])
            ->andFilterWhere(['like', 'business_name', $this->business_name])
            ->andFilterWhere(['like', 'address', $this->address])
            //->andFilterWhere(['like', 'locality', $this->locality])
            ->andFilterWhere(['like', 'province', $this->province])
            ->andFilterWhere(['like', 'country', $this->country])
            ->andFilterWhere(['like', 'delivery_date', $this->delivery_date])
            ->andFilterWhere(['like', 'payment_method', $this->payment_method])
            ->andFilterWhere(['like', 'payment_information', $this->payment_information])
            ->andFilterWhere(['like', 'order_status', $this->order_status])
            ->andFilterWhere(['like', 'created_at', $this->created_at])
            ->andFilterWhere(['like', 'updated_at', $this->updated_at])
            ->andFilterWhere(['like', 'customer_cod', $this->customer_cod])
            ->andFilterWhere(['like', 'GMV_PK_Insert_Date', $this->GMV_PK_Insert_Date])
            ->andFilterWhere(['like', 'GMV_PK', $this->GMV_PK])
            ->andFilterWhere(['like', 'shipping_address', $this->shipping_address]);

        return $dataProvider;
    }

    
}
