<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\behaviors\StatusBehaviors;
use bitcream\gmvricambi\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\helpers\ArrayHelper;
use bitcream\gmvricambi\custom\common\behaviors\LanguageBehaviors;
use yii\behaviors\SluggableBehavior;

/**
 * This is the model class for table "{{%product}}".
 *
 */
class Product extends \bitcream\gmvricambi\custom\common\models\Product
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'language' => [
                'class' => LanguageBehaviors::className(),
                'langs' => [
                    'it',
                    'en',
                    'de',
                ],
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            [
                'class' => SluggableBehavior::class,
                'attribute' => 'name',
                'slugAttribute' => 'slug',
            ],
        ]);
    }    

    public static function getTranslation($language, $articleCod, $products){        
        foreach($products as $product){
            if($product->getLanguageObject()->label == "it"){
                $productDefaultTranslated = $product;
            }else{
                $productTranslated = $product->getLanguage($language);
                if($productTranslated){
                    return $product;
                }
            }            
        }  
        return $productDefaultTranslated;
    }
}
