<?php

use yii\helpers\Html;
use yii\grid\GridView;
use bitcream\gmvricambi\custom\common\widget\ActiveOrderWidget;
use bitcream\gmvricambi\custom\common\widget\CategoryWidget;
use bitcream\gmvricambi\custom\common\models\GMVArticlesCategory;
bitcream\gmvricambi\custom\backend\Asset::register($this);
/* @var $this yii\web\View */
/* @var $searchModel bitcream\gmvricambi\custom\backend\models\GMVArticleSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('gmv', 'Gmv Articles Customer');
$this->params['breadcrumbs'][] = $this->title;
$this->params['breadcrumbs'] = GMVArticlesCategory::addBreadcrumbLink($this->params['breadcrumbs']);
?>
<div class="gmvarticle-index">
    <?= $this->render('_breadcrumb',[
        'searchModel' => $searchModel,
        'dataProvider' => $dataProvider,
    ]) ?>  
    
    <?= CategoryWidget::widget(['categorySelected' => $categorySelected]); ?>

    <h1><?= Html::encode($this->title) ?></h1>
    
    <?php  echo $this->render('_search',[
        'customerUser' => $customerUser
    ]); ?>

    <?= $this->render('_datatable',[
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
    ]) ?>


</div>
<?= ActiveOrderWidget::widget(); ?>
