<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Plant cod'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->plant_cod, [Yii::$app->controller->id.'/view','plant_cod'=>$data->plant_cod]);}
                ],
                'order_reference',
                [
                    'attribute' => 'order_confirmation_date',
                    'format' => ['date', 'php:d-m-Y']
                ], 
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>