<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
/**
 * This is the model class for table "{{%GMV_articles_category}}".
 *
 */
class GMVArticlesCategory extends base\GMVArticlesCategory
{
    public static function getCategoriesChilds($parent){
        $categories['all']  = Yii::t('gmv', 'All');        
        $gmvArticlesCategories = GMVArticlesCategory::findAll(['category_parent_id' => $parent]);
        foreach($gmvArticlesCategories as $gmvArticlesCategory){           
            $categories[$gmvArticlesCategory->id] = $gmvArticlesCategory->name; 
        }
        return $categories;
    }

    public static function getCategoryName($categoryId){        
        $category = GMVArticlesCategory::findOne(['id' => $categoryId]);
        return $category->name;
    }

    public static function addBreadcrumbLink(){
        $customer = CustomerUser::findOne(Yii::$app->user->id);
        $categorySelected = $customer->getCategorySelected();
        
        while($categorySelected != 0){
            $category = GMVArticlesCategory::findOne(['id' => $categorySelected]);
            $breadcrumbCategory[] = ['label' => Yii::t('gmv', GMVArticlesCategory::getCategoryName($category->id)), 'url' => ['set-category','category'=>$category->id]];
            $categorySelected = $category->category_parent_id;
        }
        
        return array_reverse($breadcrumbCategory);
    }

    public static function getSubcomponentCategory($category){    
        $category = GMVArticlesCategory::findOne(['id' => $category]);
        return $category->subcomponent_cod;
    }

}
