<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_article}}".
 *
 * @property string $article_cod
 * @property string $description
 * @property string|null $detail
 * @property string|null $family
 * @property string|null $unit_of_measure_cod
 * @property string|null $unit_of_measure
 * @property float|null $weight
 * @property string|null $packaging_code
 * @property string|null $assembled_product
 * @property int|null $subcomponent_cod
 * @property int|null $lead_time
 * @property float|null $availability
 * @property int|null $need_PK_order
 *
 * @property Product[] $products
 */
class GMVArticle extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_article}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['article_cod', 'description'], 'required'],
            [['weight', 'availability'], 'number'],
            [['subcomponent_cod', 'lead_time', 'need_PK_order'], 'integer'],
            [['article_cod', 'packaging_code'], 'string', 'max' => 15],
            [['description'], 'string', 'max' => 35],
            [['detail', 'assembled_product'], 'string', 'max' => 1],
            [['family'], 'string', 'max' => 3],
            [['unit_of_measure_cod'], 'string', 'max' => 2],
            [['unit_of_measure'], 'string', 'max' => 50],
            [['article_cod'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'article_cod' => Yii::t('gmv', 'Article Cod'),
            'description' => Yii::t('gmv', 'Description'),
            'detail' => Yii::t('gmv', 'Detail'),
            'family' => Yii::t('gmv', 'Family'),
            'unit_of_measure_cod' => Yii::t('gmv', 'Unit Of Measure Cod'),
            'unit_of_measure' => Yii::t('gmv', 'Unit Of Measure'),
            'weight' => Yii::t('gmv', 'Weight'),
            'packaging_code' => Yii::t('gmv', 'Packaging Code'),
            'assembled_product' => Yii::t('gmv', 'Assembled Product'),
            'subcomponent_cod' => Yii::t('gmv', 'Subcomponent Cod'),
            'lead_time' => Yii::t('gmv', 'Lead Time'),
            'availability' => Yii::t('gmv', 'Availability'),
            'need_PK_order' => Yii::t('gmv', 'Need  Pk Order'),
        ];
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProducts()
    {
        return $this->hasMany(Product::className(), ['article_cod' => 'article_cod']);
    }
}
