<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_customer}}".
 *
 * @property string $customer_cod
 * @property string $name
 * @property string|null $address
 * @property float|null $postal_code
 * @property string|null $province_cod
 * @property string|null $province
 * @property string|null $nation_cod
 * @property string|null $nation
 * @property string|null $promotions_email
 * @property string|null $business_zone_cod
 * @property string|null $business_zone
 * @property string|null $payment_term_cod
 * @property string|null $payment_term
 * @property float|null $bank_credit_limit
 * @property string|null $return_terms_cod
 * @property string|null $return_port_terms_cod
 * @property string|null $return_port
 * @property string|null $withdrawal_terms_cod
 * @property string|null $withdrawal_carrier_cod
 * @property string|null $withdrawar_carrier
 * @property string|null $shipping_address_cod
 * @property string|null $price_list_cod
 * @property string|null $vat_number
 * @property string|null $rating_cod
 */
class GMVCustomer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_customer}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_cod', 'name'], 'required'],
            [['postal_code', 'bank_credit_limit'], 'number'],
            [['customer_cod'], 'string', 'max' => 6],
            [['name', 'nation', 'business_zone', 'payment_term', 'return_port', 'withdrawar_carrier'], 'string', 'max' => 35],
            [['address', 'province', 'vat_number'], 'string', 'max' => 50],
            [['province_cod', 'business_zone_cod', 'return_terms_cod', 'return_port_terms_cod', 'withdrawal_terms_cod'], 'string', 'max' => 2],
            [['nation_cod', 'payment_term_cod', 'withdrawal_carrier_cod', 'shipping_address_cod'], 'string', 'max' => 3],
            [['promotions_email'], 'string', 'max' => 100],
            [['price_list_cod', 'rating_cod'], 'string', 'max' => 1],
            [['customer_cod'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
            'name' => Yii::t('gmv', 'Name'),
            'address' => Yii::t('gmv', 'Address'),
            'postal_code' => Yii::t('gmv', 'Postal Code'),
            'province_cod' => Yii::t('gmv', 'Province Cod'),
            'province' => Yii::t('gmv', 'Province'),
            'nation_cod' => Yii::t('gmv', 'Nation Cod'),
            'nation' => Yii::t('gmv', 'Nation'),
            'promotions_email' => Yii::t('gmv', 'Promotions Email'),
            'business_zone_cod' => Yii::t('gmv', 'Business Zone Cod'),
            'business_zone' => Yii::t('gmv', 'Business Zone'),
            'payment_term_cod' => Yii::t('gmv', 'Payment Term Cod'),
            'payment_term' => Yii::t('gmv', 'Payment Term'),
            'bank_credit_limit' => Yii::t('gmv', 'Bank Credit Limit'),
            'return_terms_cod' => Yii::t('gmv', 'Return Terms Cod'),
            'return_port_terms_cod' => Yii::t('gmv', 'Return Port Terms Cod'),
            'return_port' => Yii::t('gmv', 'Return Port'),
            'withdrawal_terms_cod' => Yii::t('gmv', 'Withdrawal Terms Cod'),
            'withdrawal_carrier_cod' => Yii::t('gmv', 'Withdrawal Carrier Cod'),
            'withdrawar_carrier' => Yii::t('gmv', 'Withdrawar Carrier'),
            'shipping_address_cod' => Yii::t('gmv', 'Shipping Address Cod'),
            'price_list_cod' => Yii::t('gmv', 'Price List Cod'),
            'vat_number' => Yii::t('gmv', 'Vat Number'),
            'rating_cod' => Yii::t('gmv', 'Rating Cod'),
        ];
    }
}
