<?php

namespace bitcream\gmvricambi\custom\common\utils;
use Yii;

/**
 * This is the class for create menu left
 */
class Menu
{

    public static function general(){

        $items = Yii::$app->params['menuItems'];

        // $exhibitionId = UserOption::getCurrentUserOne('exhibition_id');
        // $exhibitorId = UserOption::getCurrentUserOne('exhibitor_id');
        $currentUserId = Yii::$app->user->id;
        $currentUserRoles = Yii::$app->authManager->getRolesByUser($currentUserId);

        // if (!empty($currentUserRoles["storeManager"])){
        //        return array_merge($items, Menu::storeManagerItems(["submenu" => false]));
        // }

        // if (Yii::$app->user->can('viewStoreMenu')){
        //     if(true){
        //         $items = array_merge($items, Menu::storeManagerItems(["submenu" => true]));
        //     }
        // }

        if (Yii::$app->user->can('viewApplicationsItems')){
            if(true){
                $items =  Menu::applicationItems([]);
            }
        }

        if (Yii::$app->user->can('viewPartnerItems')){
            if(true){
                $items =  Menu::partnerItems([]);
            }
        }

        if (Yii::$app->user->can('viewSysadminMenu')){
            //se l'utente è amministratore
            if(true){
                $items = array_merge($items, Menu::sysAdminItems());
            }
        }
        return $items;


    }


    public static function sysAdminItems(){
        return [
            [
                'label' => Yii::t('app', 'SysAdmin'),
                'icon' => 'fontawesome fa fa-cogs',
                'url' => '#',
                'items' => [
                    [   'label' => Yii::t('app', 'Users'),
                        'url' => ['/users/user/index'],
                        'icon' => 'fontawesome fa fa-user',
                    ],
                    [
                        'label' => Yii::t('app', 'Users Permissions'),
                        'url' => ['/permissions/auth-item/auth'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [
                        'label' => Yii::t('app', 'Users Roles'),
                        'url' => ['/permissions/auth-item/rule'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [   'label' => Yii::t('app', 'Options'),
                        'url' => ['/options/option/index'],
                        'icon' => 'fontawesome fa fa-cog'
                    ],
                ]
            ],
        ];
    }

    public static function applicationItems($params){

        return Yii::$app->params['menuItems'];

    }

    public static function partnerItems($params){

        return Yii::$app->params['menuPartner'];

    }

}
