<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\ProductComponent;
use bitcream\gmvricambi\custom\backend\models\GMVArticlesCategory;
use bitcream\gmvricambi\custom\backend\models\GMVAssembledArticle;
use bitcream\gmvricambi\custom\backend\models\ProductComponentSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * ProductComponentController implements the CRUD actions for ProductComponent model.
 */
class ProductComponentController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ProductComponent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ProductComponentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ProductComponent model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id, $assembledArticle)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
            'assembledArticle' => $assembledArticle,
        ]);
    }

    /**
     * Creates a new ProductComponent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($assembledArticle)
    {
        $model = new ProductComponent();
        $gmvAssembledArticle = GMVAssembledArticle::findOne($assembledArticle);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['gmv-assembled-article/view', 'article_cod' => $assembledArticle]);
        }

        return $this->render('create', [
            'model' => $model,
            'gmvAssembledArticle' => $gmvAssembledArticle,
            'categories' => GMVArticlesCategory::find()->all(),
        ]);
    }

    /**
     * Updates an existing ProductComponent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $assembledArticle)
    {
        $model = $this->findModel($id);
        $gmvAssembledArticle = GMVAssembledArticle::findOne($assembledArticle);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['gmv-assembled-article/view', 'article_cod' => $assembledArticle]);
        }

        return $this->render('update', [
            'model' => $model,
            'gmvAssembledArticle' => $gmvAssembledArticle,
            'categories' => GMVArticlesCategory::find()->all(),
        ]);
    }

    /**
     * Deletes an existing ProductComponent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id, $assembledArticle)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['gmv-assembled-article/view', 'article_cod' => $assembledArticle]);
    }

    /**
     * Finds the ProductComponent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ProductComponent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ProductComponent::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
