<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVAgent;

/**
 * GMVAgentSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVAgent`.
 */
class GMVAgentSearch extends GMVAgent
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_cod', 'agent_cod', 'name'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVAgent::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['like', 'customer_cod', $this->customer_cod])
            ->andFilterWhere(['like', 'agent_cod', $this->agent_cod])
            ->andFilterWhere(['like', 'name', $this->name]);

        return $dataProvider;
    }
}
