<?php
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\widgets\ActiveForm;

use kartik\touchspin\TouchSpin;
use kartik\number\NumberControl;
use kartik\select2\Select2;
use bitcream\gmvricambi\custom\common\widget\AddPlantCodeWidget;

\yii\web\YiiAsset::register($this);
?>
<?php Modal::begin([
    'header' => '<h2 class="modal-title">'.Yii::t('gmv', 'Add product ').'<div class="article_cod"></div></h2>',
    'id'     => 'modal-add-product',
]); ?>
    <?php $form = ActiveForm::begin([
        'action' => ['add-product-to-order'],
        'method' => 'post',
        'id' => 'form-add-product'
    ]);
    ?>
    <div class='row'>
        <div class='col-md-12'>
            <div class='label-add-product'><?=Yii::t('gmv', 'To purchase this product, you must enter the plant code')?></div><br>
            <div class='row'>
                <div class='col-md-6'>
                    <input type="hidden" id="article_cod" name="GMVArticle[article_cod]" value="">
                    <label for="plant_code"><?=Yii::t('gmv', 'Plant code')?></label>
                    <?= AddPlantCodeWidget::widget(['multiple' => false, 'search' => true]); ?>
                </div>
                <div class='col-md-6'>
                    <label for="dimension" class="label-dimension"><?=Yii::t('gmv', 'Dimension')?></label>
                    <div class="number">
                        <?= NumberControl::widget([
                            'name' => 'OrderItem[dimension]',
                            'id' => 'dimension',
                            'value' => null,
                        ]);?>
                    </div>
                    <label for="quantity" class="label-quantity"><?=Yii::t('gmv', 'Quantity')?></label>
                    <input type="hidden" id="quantity" name="OrderItem[quantity]" value="1">
                    <div class="touchspin">
                        <?= TouchSpin::widget([
                            'name' => 'OrderItem[quantity]',
                            'id' => 'quantity-touchspin',
                            'pluginOptions' => [
                                'buttonup_class' => 'btn btn-primary', 
                                'buttondown_class' => 'btn btn-primary', 
                                'buttonup_txt' => '<i class="fa fa-plus-circle"></i>', 
                                'buttondown_txt' => '<i class="fa fa-minus-circle"></i>',
                                'step' => 1,
                                'initval' => 1,
                            ]
                        ]);?>
                    </div>
                </div>                
            </div>
            <br>
            <div class='row'>
                <div class='col-md-12'>
                    <span class='label label-success'><?=Yii::t('gmv','Disponibile')?></span>
                </div>
            </div><br>
            <div class='row'>
                <div class='col-md-12'>
                    <?=Html::button(Yii::t('gmv', 'Add to order'), ['class' => 'btn btn-default btn-block', 'id' => 'add-product-action-modal']);?>
                </div>
            </div>
        </div>
    </div>
    <?php ActiveForm::end();?>
<?php Modal::end(); ?>
