<?php

use yii\helpers\Html;
use bitcream\gmvricambi\custom\common\widget\ActionWidget;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */
bitcream\gmvricambi\custom\backend\Asset::register($this);

$this->title = Yii::t('gmv', 'Update Order: {name}', [
    'name' => $model->name,
]);
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->name, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('gmv', 'Update');
?>
<div class="order-update">

    <h1><?= Html::encode($this->title) ?></h1>

    <?php
        $actionButtons =  [
            [
                'type' => 'back',
                'url' => ['view', 'id' => $model->id]
            ],
        ];
        echo ActionWidget::widget(['model' => $model, 'customButtons' => $actionButtons, 'categoryMessage' => 'gmv']);
    ?>

    <?= $this->render('_form', [
        'model' => $model,
        'order' => $order,
        'countries' => $countries,
        'provinces' => $provinces,
        'shippingAddress' => $shippingAddress,
    ]) ?>

</div>
