<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMVSparePartsForOrder}}".
 *
 */
class GMVSparePartsForOrder extends base\GMVSparePartsForOrder
{
    /**
     * @inheritdoc $primaryKey
     */
    public static function primaryKey()
    {
        return ["plant_cod"];
    }

    public static function getArticleCod($plantCode){
        $articleList = array();
        $articles = GMVSparePartsForOrder::find()
                        ->select('article_cod')
                        ->where([
                                    'plant_cod' => $plantCode
                                ])
                        ->all();

        foreach($articles as $article){
            array_push($articleList, $article['article_cod']);
        }

        return $articleList;
    }

    public static function getCustomerPlant(){
        $plantsCodeCustomer = ['10PK010460', '10PK010485', '10PK010279'];
        return GMVSparePartsForOrder::findAll(['plant_cod' => $plantsCodeCustomer]);
    }
}
