<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_country}}".
 *
 * @property string $country_cod
 * @property string|null $description
 */
class GMVCountry extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_country}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['country_cod'], 'required'],
            [['country_cod'], 'string', 'max' => 3],
            [['description'], 'string', 'max' => 35],
            [['country_cod'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'country_cod' => Yii::t('gmv', 'Country Cod'),
            'description' => Yii::t('gmv', 'Description'),
        ];
    }
}
