<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVSparePartsForOrder;
use bitcream\gmvricambi\custom\backend\models\GMVSparePartsForOrderSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GMVSparePartsForOrderController implements the CRUD actions for GMVSparePartsForOrder model.
 */
class GmvSparePartsForOrderController extends Controller
{
    
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVSparePartsForOrder models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVSparePartsForOrderSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GMVSparePartsForOrder model.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($plant_cod)
    {
        return $this->render('view', [
            'model' => $this->findModel($plant_cod),
        ]);
    }

    /**
     * Creates a new GMVSparePartsForOrder model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVSparePartsForOrder();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'plant_cod' => $model->plant_cod]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVSparePartsForOrder model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($plant_cod)
    {
        $model = $this->findModel($plant_cod);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'plant_cod' => $model->plant_cod]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVSparePartsForOrder model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($plant_cod)
    {
        $this->findModel($plant_cod)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVSparePartsForOrder model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return GMVSparePartsForOrder the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($plant_cod)
    {
        if (($model = GMVSparePartsForOrder::findOne($plant_cod)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
