<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\behaviors\StatusBehaviors;
use bitcream\gmvricambi\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use yii\behaviors\SluggableBehavior;

/**
 * This is the model class for table "{{%order_item}}".
 *
 */
class OrderItem extends \bitcream\gmvricambi\custom\common\models\OrderItem
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            [
                'class' => SluggableBehavior::class,
                'attribute' => 'name',
                'slugAttribute' => 'slug',
            ]
        ]);
    }

    public function addOrderItem($articlePost, $orderItemPost, $plantCode){
        
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);        
        $order = Order::findOne($customerUser->getActiveOrder()->id);

        $language = $customerUser->customer->language;
        $products = Product::find()->where(['article_cod' => $articlePost['article_cod'], 'status' => '30'])->all();
        if(!empty($products)){
            if(!empty($language)){
                $productTranslated = Product::getTranslation($language, $articlePost['article_cod'], $products); 
            }
        }
        
        $GMVArticle = GMVArticle::findOne($articlePost['article_cod']);
        $searchOrderItem = OrderItem::searchOrderItem($articlePost['article_cod'], $order, $plantCode);
        if((!$searchOrderItem || (!empty($orderItemPost['dimension']))) || ($searchOrderItem && $searchOrderItem->plant_code != $plantCode)){
            $orderItem = new OrderItem();
            $orderItem->name = (isset($productTranslated))? $productTranslated->name : $GMVArticle->description;
            $orderItem->slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $orderItem->name)));
            $orderItem->plant_code = $plantCode;
            $orderItem->product_price = $GMVArticle->price;
            $orderItem->family = $GMVArticle->family;
            $orderItem->discount_1 = $GMVArticle->discount1;
            $orderItem->discount_2 = $GMVArticle->discount2;
            $orderItem->discount_3 = $GMVArticle->discount3;
            $orderItem->discount_4 = $GMVArticle->discount4;
            $orderItem->discount_5 = $GMVArticle->discount5;
            $orderItem->quantity = (float)$orderItemPost['quantity'];
            $orderItem->dimension = (!empty($orderItemPost['dimension']))? (float)$orderItemPost['dimension'] : NULL;
            $orderItem->orderitem_status = "30";
            $orderItem->order_id = $customerUser->getActiveOrder()->id;            
            $orderItem->article_cod = $GMVArticle->article_cod;
        }else{
            $orderItem = OrderItem::findOne($searchOrderItem->id);
            $orderItem->quantity = $orderItem->quantity + (float)$orderItemPost['quantity'];
        }
        $orderItem->total_price = (!empty($orderItemPost['dimension']))? $GMVArticle->price * (float)$orderItemPost['dimension']:  $GMVArticle->price * $orderItem->quantity;
        $orderItem->article_cod = $GMVArticle->article_cod;
        $resultSave = $orderItem->save();
        $total = $order->updateTotal();
        $result = [
            "result" => $resultSave,
        ];
        return $result;
    }

    public static function updateQuantityOrder($id, $quantity){        
        $orderItem = OrderItem::findOne($id);
        $orderItem->quantity = $quantity;
        return $orderItem->save(); 
    }

    
}
