<?php
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\widgets\ActiveForm;

use kartik\touchspin\TouchSpin;

\yii\web\YiiAsset::register($this);
?>
<?php Modal::begin([
    'header' => '<h2 class="modal-title">'.Yii::t('gmv', 'Update quantity product ').'<div class="article_cod"></div></h2>',
    'id'     => 'modal-update-quantity-product',
]); ?>
    <?php $form = ActiveForm::begin([
        'action' => ['update-quantity-product-to-order'],
        'method' => 'post',
        'id' => 'form-update-quantity-product'
    ]);
    ?>
    <div class='row'>
        <div class='col-md-12'>
            <div class='label-add-product'><?=Yii::t('gmv', 'To purchase this product, you must enter the plant code')?></div><br>
            <div class='row'>
                <div class='col-md-12'>
                    <label for="quantity" class="label-quantity"><?=Yii::t('gmv', 'Quantity')?></label>
                    <input type="hidden" id="quantity-update" name="OrderItem[quantity]" value="">
                    <input type="hidden" id="order-item-id" name="OrderItem[id]" value="">
                    <div class="touchspin">
                        <?= TouchSpin::widget([
                            'name' => 'OrderItem[quantity]',
                            'id' => 'quantity-touchspin',
                            'pluginOptions' => [
                                'buttonup_class' => 'btn btn-primary', 
                                'buttondown_class' => 'btn btn-primary', 
                                'buttonup_txt' => '<i class="fa fa-plus-circle"></i>', 
                                'buttondown_txt' => '<i class="fa fa-minus-circle"></i>',
                                'step' => 1,
                                'initval' => 1,
                                'min' => 1,
                            ]
                        ]);?>
                    </div>
                </div>                
            </div>
            <br>
            <div class='row'>
                <div class='col-md-12'>
                    <span class='label label-success'><?=Yii::t('gmv','Disponibile')?></span>
                </div>
            </div><br>
            <div class='row'>
                <div class='col-md-12'>
                    <?=Html::button(Yii::t('gmv', 'Update quantity product'), ['class' => 'btn btn-default btn-block', 'id' => 'update-quantity-product-action-modal']);?>
                </div>
            </div>
        </div>
    </div>
    <?php ActiveForm::end();?>
<?php Modal::end(); ?>
