<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\ActionWidget;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <?php
        $actionButtons =  [
            [
                'type' => 'create',
            ],
            [
                'type' => 'update',
            ],
            [
                'type' => 'delete',
            ],
        ];
        echo ActionWidget::widget(['model' => $model, 'customButtons' => $actionButtons, 'categoryMessage' => 'gmv']);
    ?>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'name',
            'order_date',
            'address',
            'locality',
            'province',
            'postal_code',
            'country',
            'shipping_address',
            'delivery_date',
            'customer_cod',
            'plant_reference',
            'order_reference',
            'total',
        ],
    ]) ?>

    <?= $this->render('_datatable-orderitem',[
            'searchModel' => $searchModelOrderItem,
            'dataProvider' => $dataProviderOrderItem,
    ]) ?>

</div>
