<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_order_other}}".
 *
 * @property string|null $plant_cod
 * @property string|null $order_reference
 * @property string|null $plant_reference
 * @property string|null $plant_type
 * @property string|null $order_confirmation_date
 * @property string|null $offer_number
 * @property int|null $Protocollo
 * @property string|null $customer_cod
 * @property string|null $order_status
 */
class GMVOrderOther extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_order_other}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_confirmation_date'], 'safe'],
            [['Protocollo'], 'integer'],
            [['plant_cod'], 'string', 'max' => 10],
            [['order_reference', 'plant_reference'], 'string', 'max' => 25],
            [['plant_type', 'order_status'], 'string', 'max' => 20],
            [['offer_number'], 'string', 'max' => 15],
            [['customer_cod'], 'string', 'max' => 6],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'plant_cod' => Yii::t('app', 'Plant Cod'),
            'order_reference' => Yii::t('app', 'Order Reference'),
            'plant_reference' => Yii::t('app', 'Plant Reference'),
            'plant_type' => Yii::t('app', 'Plant Type'),
            'order_confirmation_date' => Yii::t('app', 'Order Confirmation Date'),
            'offer_number' => Yii::t('app', 'Offer Number'),
            'Protocollo' => Yii::t('app', 'Protocollo'),
            'customer_cod' => Yii::t('app', 'Customer Cod'),
            'order_status' => Yii::t('app', 'Order Status'),
        ];
    }
}
