<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_paymentMethod}}".
 *
 * @property string $payment_cod
 * @property string|null $description
 */
class GMVPaymentMethod extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_paymentMethod}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['payment_cod'], 'required'],
            [['payment_cod'], 'string', 'max' => 3],
            [['description'], 'string', 'max' => 35],
            [['payment_cod'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'payment_cod' => Yii::t('gmv', 'Payment Cod'),
            'description' => Yii::t('gmv', 'Description'),
        ];
    }
}
