<?php

namespace bitcream\gmvricambi\custom\common\utils;
use Yii;

/**
 * This is the class for Stripe payment
 */
class Stripe
{
    public static function sendPayment($order){
        $stripe = new \Stripe\StripeClient(
            Yii::$app->params['stripeToken']
        );
        $response = $stripe->checkout->sessions->create([
            'success_url' => Yii::$app->params['backendUrl'].'/custom/order-customer/payment-success?id='.$order->id,
            'cancel_url' => Yii::$app->params['backendUrl'].'/custom/order-customer/view?id='.$order->id,
            'payment_method_types' => ['card'],
            'line_items' => [
                Stripe::getLineItems($order->orderItems)
            ],
            'mode' => 'payment',
        ]);

        return $response;

    }

    public static function getLineItems($orderItems){
        $lineItems = array();
        foreach($orderItems as $orderItem){
            $unitAmount = (int)($orderItem['total_price']*100);
            $lineItem = [
                'price_data' => [
                'currency' => 'eur',
                'product_data' => [
                    'name' => $orderItem['name'],
                ],
                'unit_amount' => $unitAmount,
                ],
                'quantity' => (int)$orderItem['quantity'],
            ];
            array_push($lineItems, $lineItem);
        }

        return $lineItems;
    }
}