<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%GMV_article}}`
 */
class M210820123723AddArticleCodColumnToProductTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product}}', 'article_cod', $this->string()->null());

        // creates index for column `article_cod`
        $this->createIndex(
            '{{%idx-product-article_cod}}',
            '{{%product}}',
            'article_cod'
        );

        // add foreign key for table `{{%GMV_article}}`
        $this->addForeignKey(
            '{{%fk-product-article_cod}}',
            '{{%product}}',
            'article_cod',
            '{{%GMV_article}}',
            'article_cod',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%GMV_article}}`
        $this->dropForeignKey(
            '{{%fk-product-article_cod}}',
            '{{%product}}'
        );

        // drops index for column `article_cod`
        $this->dropIndex(
            '{{%idx-product-article_cod}}',
            '{{%product}}'
        );

        $this->dropColumn('{{%product}}', 'article_cod');
    }
}
