<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVArticle;
use bitcream\gmvricambi\custom\backend\models\GMVArticleCustomerSearch;
use bitcream\gmvricambi\custom\backend\models\Product;
use bitcream\gmvricambi\custom\backend\models\ProductImage;
use bitcream\gmvricambi\custom\backend\models\OrderItem;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * GmvArticleController implements the CRUD actions for GMVArticle model.
 */
class GmvArticleCustomerController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVArticle models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVArticleCustomerSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        if(isset($_GET['plant_cod'])){
            $customerUser->setPlantCodeSelected($_GET['plant_cod']);
        }
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'customerUser' => $customerUser,
            'categorySelected' => $customerUser->getCategorySelected(),
        ]);
    }

   
    /**
     * Displays a single GMVArticle model.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($article_cod)
    {
        $orderItem = new OrderItem();
        $GMVArticle = $this->findModel($article_cod);
        $attributeView = $GMVArticle->getAttributeTranslation();

        return $this->render('view', [
            'model' => $this->findModel($article_cod),
            'orderItem' => $orderItem,
            'attributeView' => $attributeView,
            'productImage' => ProductImage::getProductImage($article_cod),
            'plantCodes' => GMVArticle::getPlantsCodes($article_cod),
        ]);
    }

    public function actionAddProductToOrder(){

        $orderItem = new OrderItem();
        $result = $orderItem->addOrderItem(Yii::$app->request->post()['GMVArticle'], Yii::$app->request->post()['OrderItem'], (isset(Yii::$app->request->post()['plant_code'])?Yii::$app->request->post()['plant_code']: ""));    
        
        if($result['result']){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionSetFilter($article_cod, $plant_code){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $customerUser->setArticleCodSelected($article_cod);
        $customerUser->setPlantCodeSelected($plant_code);
        return $this->redirect(['index']);
    }

    public function actionResetFilter(){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $customerUser->unsetArticleCodSelected();
        $customerUser->unsetPlantCodeSelected();
        return $this->redirect(['index']);
    }

    public function actionSetCategory($category){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $customerUser->setCategorySelected($category);
        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVArticle model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return GMVArticle the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GMVArticle::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
