<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use bitcream\gmvricambi\custom\common\models\GMVArticle;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'orderitem-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                'article_cod',
                'name',
                [
                    'attribute'=>Yii::t('gmv', 'Quantity'),
                    'format'=>'raw',
                    'value' => function($data)
                    {
                        if(!empty($data->dimension)){
                            return $data->quantity."x".$data->dimension." ".$data->gmvArticle->unit_of_measure_cod;
                        }
                        return $data->quantity;
                    }
                ],
                'product_price',
                'total_price',
                [
                    'format'=>'raw',
                    'label' => Yii::t('gmv', 'Plant code'),
                    'value' => function($data)
                    {
                        $gmvArticle = GMVArticle::findOne($data->article_cod);
                        if($gmvArticle->need_PK_order == 1 && $data->plant_code == ""){ 
                            return "<span class='plant_message'>".Yii::t('gmv','Missing plant code')."</span>";
                        }
                        return $data->plant_code;
                    }
                ],
                'note',
                [
                    'format'=>'raw',
                    'label' => 'Azioni',
                    'value' => function ($model, $key, $index, $column) use ($order)
                    {
                        $actions = "";
                        if($order->order_status == "processing"){                            
                            $gmvArticle = GMVArticle::findOne($model->article_cod);
                            if($order->showActionOrderItem()){
                                $actions = Html::a("<i class='fa fa-trash-o'></i>", ['order-item/delete', 'id'=> $model->id],                    
                                [
                                    'class' => 'btn btn-danger action-button',
                                    'data' => [
                                        'confirm' => Yii::t('gmv','Are you sure you want to delete this order item?'),
                                        'method' => 'post',
                                    ]
                                ]);
                            }
                            $actions .= Html::button("<i class='fa fa-pencil'></i> ".Yii::t('gmv', 'Update'),  [                                                       
                                'data-toggle' => 'modal',
                                'data-target' => '#modal',
                                'data-id'     => $model->article_cod,
                                'data-value'  => $model->quantity,
                                'data-dynamic'  => $gmvArticle->isDynamicDimension(),
                                'data-title'  => $model->name,
                                'data-order-item-id'  => $model->id,
                                'data-order-id'  => $model->order_id,
                                'data-plant'     => $gmvArticle->need_PK_order,
                                'data-plant-code'     => $model->plant_code,
                                'data-note'     => $model->note,
                                'data-dimension'     => $model->dimension,
                                'id'          => 'popupModalUpdateQuantityProduct',      
                                'class' => 'btn btn-success popup-modal-update-quantity-product',                  
                            ]);
                        }  
                        return $actions;
                        
                        
                    }
                ],
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
    <?= $this->render('_modal')?>
</div>