<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\ActionWidget;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <?php
        $actionButtons =  [
            [
                'type' => 'create',
            ],
            [
                'type' => 'update',
            ],
            [
                'type' => 'delete',
            ],
        ];
        echo ActionWidget::widget(['model' => $model, 'customButtons' => $actionButtons, 'categoryMessage' => 'gmv']);
    ?>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'name',
            [
                'label'  => Yii::t('gmv','Order date'),
                'value'  =>  date("d/m/Y", $model->order_date)
            ],
            'address',
            'locality',
            'province',
            'postal_code',
            'country',
            'shipping_address',
            [
                'label'  => Yii::t('gmv','Delivery date'),
                'value'  =>  date("d/m/Y", $model->delivery_date)
            ],
            'customer_cod',
            [
                'label'  => 'Plant reference',
                'value'  =>  (!empty($model->plant_reference))? json_encode(unserialize($model->plant_reference)) : Yii::t('gmv','Missing plant code'),
                'contentOptions' => ['class' => (empty($model->plant_reference))? 'plant_message': ''],
            ],
            'order_reference',
            'courier_subscription_code',
            'total',
            'shipping_term',  
            [
                'label'  => Yii::t('gmv','Confirm date'),
                'value'  =>  date("d/m/Y", $model->confirm_date)
            ],
        ],
    ]) ?>

    <?= $this->render('_datatable-orderitem',[
            'searchModel' => $searchModelOrderItem,
            'dataProvider' => $dataProviderOrderItem,
    ]) ?>

</div>
