<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use Emberware\Evidia\Model\GotifySender\behaviors\SendNotification;
use bitcream\gmvricambi\custom\common\behaviors\OrderStatusBehaviors;
use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;
/**
 * This is the model class for table "{{%order}}".
 *
 */
class Order extends base\Order
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'send-notification' => [
                'class' => SendNotification::className(),
                'messageType' => [
                    'update' => 'orderUpdated',
                    'delete' => 'orderDeleted',
                    'create' => 'orderCreated',
                ],
                'messages' => [
                    ActiveRecord::EVENT_AFTER_UPDATE => 'orderUpdated',
                    ActiveRecord::EVENT_AFTER_INSERT => 'orderCreated',
                    ActiveRecord::EVENT_BEFORE_DELETE => 'orderDeleted',
                    OrderStatusBehaviors::EVENT_AFTER_ORDER_SEND => 'orderSent',
                    OrderStatusBehaviors::EVENT_AFTER_ORDER_ACTIVE => 'orderActivated',
                ]
            ],
            'order_status' => [
                'class' => OrderStatusBehaviors::className(),
            ],
        ]);
    }

    /**
     * Gets query for [[CustomerCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(GMVCustomer::className(), ['customer_cod' => 'customer_cod']);
    }

    public function updateTotal(){
        $this->total = 0;
        foreach($this->orderItems as $orderItem){
            $this->total = $this->total + $orderItem->total_price;
        }
        $this->save();
        return $this->total;
    }

    public function getTotal(){
        return $this->updateTotal();
    }

    public function getOrderItems(){
        return OrderItem::find()->where(['status' => '30', 'order_id' => $this->id])->all();
    }

    // public function addToTotal($total){        
    //     $this->total = $this->total + $total;
    //     $this->save();
    //     return $this->total;
    // }

    // public function removeToTotal($orderItem){        
    //     $this->total = $this->total - $orderItem->total_price;
    //     $this->save();
    //     return $this->total;
    // }

    /**
     * Controlla metodo pagamento:
     * - se coerente e validato cambia stato all'ordine
     */
    public function confirm($paymentMethodCod, $total){
        if(!$this->customer->checkPaymentMethod($paymentMethodCod, $total)) return false;
        
        if(GMVPaymentMethod::isInstantPayment($paymentMethodCod)){
            //TODO: if(!$this->isPayed) return false; //controlla che risulti pagato l'ordine
            $this->payment_method = $paymentMethodCod;
            $this->confirm_date = time();
            $this->delivery_date = $this->setDeliveryDate($this->confirm_date);
            $this->save();
            return true;  
        }
        $this->payment_method = $paymentMethodCod;        
        $this->confirm_date = time();
        $this->delivery_date = $this->setDeliveryDate($this->confirm_date);
        $this->save();
        $this->sendOrder(); //stato inviato ordine a gmv   
    }

    public function rules()
    {
        return [
            [['name'], 'required'],
           //[['shipping_address'], 'required', 'when' => function ($model) { return $model->address == ""; }, 'message' => 'Please choose a shipping address.'],
            [['province', 'address','locality', 'country'],'required', 'when' => function ($model) { return $model->shipping_address == ""; }, 'whenClient' => "function (attribute, value) { return $('#order-shipping_address').val() == '';}"],
            [['shipping_address'],'required', 'when' => function ($model) { return $model->address == ""; }, 'whenClient' => "function (attribute, value) { return $('#order-address').val() == '';}"]
            
        ];
    }

    
    public static function localityList($customerUser)
    {
        $localities['all']  = Yii::t('gmv', 'All destination');
        $orders = Order::find()->where(['customer_cod' => $customerUser->customerCod, 'order_status' => $customerUser->getOrdersStatusSelected()])->all();
        foreach($orders as $order){
            $localities[$order->locality] = $order->locality;            
        }
        return $localities;
    }

    public function duplicateOrder(){
        $copyOrder = clone $this;
        $copyOrder->isNewRecord = true;
        foreach ($this->getPrimaryKey(true) as $field => $value) {
            unset($copyOrder->{$field});
        }
        $copyOrder->name = Yii::t('gmv', 'Copy of')." ".$this->name;
        $copyOrder->order_date = (string)time();
        $copyOrder->order_status = "processing";
        $copyOrder->plant_reference = "";
        $copyOrder->status = "30";
        $copyOrder->created_at = (string)time();
        $copyOrder->updated_at = (string)time();
        $copyOrder->save();

        $orderItems = $this->orderItems;
        if(!empty($orderItems)){
            foreach($orderItems as $orderItem){
                $cloneOrderItem = new OrderItem;
                $cloneOrderItem->attributes = $orderItem->attributes;
                $cloneOrderItem->order_id = $copyOrder->id;
                $cloneOrderItem->created_at = (string)time();
                $cloneOrderItem->updated_at = (string)time();
                $cloneOrderItem->plant_code = "";
                $cloneOrderItem->save();    
            }
        }
        return $copyOrder;        
    }

    public function setDeliveryDate($date){
        $maxDay = 0;
        if(isset($this->orderItems)){
            foreach($this->orderItems as $orderItem){
                if($orderItem->gmvArticle->lead_time > $maxDay){
                    $maxDay = $orderItem->gmvArticle->lead_time;
                } 
            }
            $stringMaxDay = "+".$maxDay." days";
            return strtotime(date("Y-m-d H:i:s", $date) . $stringMaxDay);
        }
        return $date;
    }
}
