<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_order}}".
 *
 * @property string $plant_cod
 * @property string|null $order_reference
 * @property string|null $plant_reference
 * @property string|null $plant_type
 * @property string|null $order_confirmation_date
 * @property string|null $offer_number
 * @property int $Protocollo
 * @property string|null $order_status
 * @property string|null $customer_cod
 */
class GMVOrder extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_order}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['plant_cod', 'Protocollo'], 'required'],
            [['order_confirmation_date'], 'safe'],
            [['Protocollo'], 'integer'],
            [['plant_cod'], 'string', 'max' => 10],
            [['order_reference', 'plant_reference'], 'string', 'max' => 25],
            [['plant_type', 'order_status'], 'string', 'max' => 20],
            [['offer_number'], 'string', 'max' => 15],
            [['customer_cod'], 'string', 'max' => 6],
            [['plant_cod'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'plant_cod' => Yii::t('gmv', 'Plant Cod'),
            'order_reference' => Yii::t('gmv', 'Order Reference'),
            'plant_reference' => Yii::t('gmv', 'Plant Reference'),
            'plant_type' => Yii::t('gmv', 'Plant Type'),
            'order_confirmation_date' => Yii::t('gmv', 'Order Confirmation Date'),
            'offer_number' => Yii::t('gmv', 'Offer Number'),
            'Protocollo' => Yii::t('gmv', 'Protocollo'),
            'order_status' => Yii::t('gmv', 'Order Status'),
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
        ];
    }
}
