<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\touchspin\TouchSpin;
use kartik\number\NumberControl;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use bitcream\gmvricambi\custom\common\widget\AddPlantCodeWidget;

/* @var $this yii\web\View */
/* @var $searchModel bitcream\gmvricambi\custom\backend\models\OrderSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
bitcream\gmvricambi\custom\common\widget\AssetWidget::register($this);
$this->title = Yii::t('gmv', 'Orders');
$this->params['breadcrumbs'][] = $this->title;

$form = ActiveForm::begin([
    'action' => ['add-product-to-order'],
    'method' => 'post',
    'id' => 'form-add-product'
]);
?>
    <div class='row'>
        <div class='col-md-5'>
            <?=$form->field($articleModel, 'article_cod')->hiddenInput(['value'=> $articleModel->article_cod])->label(false);?>      
            <?php if($articleModel->need_PK_order != 0){ ?>
                <div class='label-add-product'><?=Yii::t('gmv', 'To purchase this product, you must enter the plant code')?></div>
                <div class='row'>
                    <div class='col-md-12'>                                      
                        <?= AddPlantCodeWidget::widget(['multiple' => false, 'search' => true]); ?>
                    </div>
                </div>
                <br>
            <?php }?>
            <div class='row'>
                <div class='col-md-6'>
                    <?php if($articleModel->isDynamicDimension()== "true"){ ?>   
                        <label for="dimension" class="label-dimension"><?=Yii::t('gmv', 'Dimension')?></label>                     
                        <?= $form->field($orderItemModel, 'dimension')->widget(NumberControl::classname(), [
                                'name' => 'dimension',
                                'value' => null,
                            ])->label(false);
                        ?>
                        <?=$form->field($orderItemModel, 'quantity')->hiddenInput(['value'=> '1'])->label(false);?>
                    <?php }else{ ?>
                        <label for="quantity" class="label-quantity"><?=Yii::t('gmv', 'Quantity')?></label>
                        <?= $form->field($orderItemModel, 'quantity')->widget(TouchSpin::classname(), [
                            'pluginOptions' => [
                                'buttonup_class' => 'btn btn-primary', 
                                'buttondown_class' => 'btn btn-primary', 
                                'buttonup_txt' => '<i class="fa fa-plus-circle"></i>', 
                                'buttondown_txt' => '<i class="fa fa-minus-circle"></i>',
                                'step' => 1,
                                'initval' => 1,
                            ]
                        ])->label(false);?>
                    <?php } ?>
                </div>
                <div class='col-md-6'>
                    <br>
                    <?=Html::button(Yii::t('gmv', 'Add to order'), ['class' => 'btn btn-default btn-block', 'id' => 'add-product-action']);?>
                </div>                  
            </div>
            <div class='row'>
                <div class='col-md-12'>
                    <span class='label label-success'><?=$articleModel->checkAvailability()?></span>
                </div>
            </div><br>
        </div>
    </div>
<?php ActiveForm::end();?>