<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%order}}`.
 */
class M210820114850CreateOrderTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%order}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(255)->null(),
            'slug' => $this->string(255)->null(),       
            'order_date' => $this->string(255)->null(),       
            'address' => $this->string(255)->null(),       
            'locality' => $this->string(255)->null(),       
            'postal_code' => $this->integer(11)->null(),    
            'country' => $this->string(255)->null(),    
            'default_address' => $this->boolean()->null(),   
            'delivery_date' => $this->string(255)->null(),     
            'payment_method' => $this->string(255)->null(), 
            'payment_information' => $this->string(255)->null(),    
            'total' => $this->float()->null(),  
            'order_status' => $this->string(255)->null(),     
            'status' =>$this->integer(11)->null(),
            'created_at' =>$this->string(255)->null(),
            'created_user_id' => $this->integer(11)->null(),
            'updated_at' =>$this->string(255)->null(),
            'updated_user_id' => $this->integer(11)->null(),
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%order}}');
    }
}
