<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVOrder;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

/**
 * GMVOrderSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVOrder`.
 */
class GMVOrderSearch extends GMVOrder
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['plant_cod', 'order_reference', 'plant_reference', 'plant_type', 'order_confirmation_date', 'offer_ number', 'order_status', 'cod_customer'], 'safe'],
            [['Protocollo'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVOrder::find()->orderBy(['order_confirmation_date' => SORT_DESC])->limit(50);
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        //$customerUser = CustomerUser::findOne(Yii::$app->user->id);
        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        // if(!$params){
        //     $query->where('0=1');
        //     return $dataProvider; 
        // }else{
        //     foreach($params as $key => $value){
        //         // grid filtering conditions
        //         $query->andFilterWhere([
        //             $key => $value,
        //         ]);
        //     }
        // }

        foreach($params as $key => $value){
            // grid filtering conditions
            $query->andFilterWhere([
                $key => $value,
            ]);
        }

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            $query->where('0=1');
            return $dataProvider;
        }

        if(isset($customerUser->customerCod) && array_keys(Yii::$app->authManager->getRolesByUser(1))[0] != "admin"){
            $query->andFilterWhere(
                ['=', 'customer_cod', $customerUser->customerCod]
            );
        }
       
        
        // grid filtering conditions
        $query->andFilterWhere([
            'order_confirmation_date' => $this->order_confirmation_date,
            'Protocollo' => $this->Protocollo,
        ]);

        $query->andFilterWhere(['like', 'plant_cod', $this->plant_cod])
            ->andFilterWhere(['like', 'order_reference', $this->order_reference])
            ->andFilterWhere(['like', 'plant_reference', $this->plant_reference])
            ->andFilterWhere(['like', 'plant_type', $this->plant_type])
            ->andFilterWhere(['like', 'offer_ number', $this->offer_number])
            ->andFilterWhere(['like', 'order_status', $this->order_status])
            ->andFilterWhere(['like', 'cod_customer', $this->order_status]);

        return $dataProvider;
    }
}
