<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                'id',
                ['attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->name, [Yii::$app->controller->id.'/view','id'=>$data->id]);}
                ],
                'order_reference',
                'order_status',
                [
                    'attribute' => 'updated_at',
                    'format' => ['date', 'php:d-m-Y']
                ], 
                'order_status',
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('gmv', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>