<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_shippingAddress}}".
 *
 * @property string $customer_cod
 * @property string $shipping_address_cod
 * @property string $datetime
 * @property string $business_name_address
 * @property string|null $address
 * @property string|null $locality
 * @property float|null $postal_code
 * @property string|null $province
 * @property string $nation
 */
class GMVShippingAddress extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        return \Yii::$app->gmv;  
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_shippingAddress}}';
    }
    
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_cod', 'shipping_address_cod', 'datetime', 'business_name_address', 'nation'], 'required'],
            [['datetime'], 'safe'],
            [['postal_code'], 'number'],
            [['customer_cod'], 'string', 'max' => 6],
            [['shipping_address_cod', 'nation'], 'string', 'max' => 3],
            [['business_name_address', 'address', 'locality'], 'string', 'max' => 35],
            [['province'], 'string', 'max' => 2],
            [['customer_cod', 'shipping_address_cod', 'business_name_address'], 'unique', 'targetAttribute' => ['customer_cod', 'shipping_address_cod', 'business_name_address']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
            'shipping_address_cod' => Yii::t('gmv', 'Shipping Address Cod'),
            'datetime' => Yii::t('gmv', 'Datetime'),
            'business_name_address' => Yii::t('gmv', 'Business Name Address'),
            'address' => Yii::t('gmv', 'Address'),
            'locality' => Yii::t('gmv', 'Locality'),
            'postal_code' => Yii::t('gmv', 'Postal Code'),
            'province' => Yii::t('gmv', 'Province'),
            'nation' => Yii::t('gmv', 'Nation'),
        ];
    }
}
