<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_shipping_cost}}".
 *
 * @property int $zone_cod
 * @property string $forwarder_cod
 * @property float $weight
 * @property float $shipment_cost
 * @property float $extra_cost_zone
 * @property float $insurance
 * @property float $gmv_markup
 * @property float $extra_max_weight
 * @property string $shipment_type
 */
class GMVShippingCost extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        return \Yii::$app->gmv;  
    }
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_shipping_cost}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['zone_cod', 'forwarder_cod', 'weight', 'shipment_cost', 'extra_cost_zone', 'insurance', 'gmv_markup', 'extra_max_weight', 'shipment_type'], 'required'],
            [['zone_cod'], 'integer'],
            [['weight', 'shipment_cost', 'extra_cost_zone', 'insurance', 'gmv_markup', 'extra_max_weight'], 'number'],
            [['forwarder_cod'], 'string', 'max' => 5],
            [['shipment_type'], 'string', 'max' => 1],
            [['zone_cod', 'forwarder_cod', 'weight', 'shipment_cost', 'shipment_type'], 'unique', 'targetAttribute' => ['zone_cod', 'forwarder_cod', 'weight', 'shipment_cost', 'shipment_type']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'zone_cod' => Yii::t('gmv', 'Zone Cod'),
            'forwarder_cod' => Yii::t('gmv', 'Forwarder Cod'),
            'weight' => Yii::t('gmv', 'Weight'),
            'shipment_cost' => Yii::t('gmv', 'Shipment Cost'),
            'extra_cost_zone' => Yii::t('gmv', 'Extra Cost Zone'),
            'insurance' => Yii::t('gmv', 'Insurance'),
            'gmv_markup' => Yii::t('gmv', 'Gmv Markup'),
            'extra_max_weight' => Yii::t('gmv', 'Extra Max Weight'),
            'shipment_type' => Yii::t('gmv', 'Shipment Type'),
        ];
    }
}
