<?php
setlocale(LC_ALL, 'it_IT.UTF-8');
date_default_timezone_set("Europe/Rome");
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);
return [
    'id' => 'app-api',
    'basePath' => dirname(__DIR__),
    'controllerNamespace' => 'api\controllers',
    'bootstrap' => ['log', 'emberware\evidia\users\api\models\Bootstrap', ],
    // 'as corsFilter'  => [
    //     'class' => \yii\filters\Cors::className(),
    //     'cors'  => \emberware\evidia\cors\common\models\Cors::corsFilter(),
    // ],
    'language' => 'it-IT',
    'sourceLanguage' => 'it-IT',
    'modules' => [
        'users' => [
            'class' => 'emberware\evidia\users\api\Module',
        ],
        'options' => [
            'class' => 'emberware\evidia\options\api\Module',
        ],
        'permissions' => [
            'class' => 'emberware\evidia\permissions\api\Module',
        ],
        'cors' => [
            'class' => 'emberware\evidia\cors\api\Module',
        ],
        'custom' => [
            'class' => 'bitcream\gmvricambi\custom\api\Module',
        ],
        //modules for api
    ],
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-api',
            'enableCookieValidation' => false,
        ],
        // 'as myBehavior' => CorsController::className(),
        // 'as myBehavior3' => [
        //     'class' => CorsController::className(),
        // ],
        'user' => [
            // module for login
            'identityClass' => 'emberware\evidia\users\common\models\User',
            'enableAutoLogin' => false,
        ],
        'session' => [
            // this is the name of the session cookie used for login api
            'name' => 'advanced-api',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'urlManager' => [
            'class' => 'yii\web\UrlManager',
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                //rules for api
                [
                    'class' => 'yii\rest\UrlRule',
                    'controller' => ['order' => 'custom/order'],
                    'except' => ['delete', 'create', 'update'],
                ],
            ],
        ],
    ],
    'params' => $params,
    // 'as corsFilter'  => [
    //     'class' => \emberware\evidia\cors\common\models\Cors::className(),
    // ],
];
