<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-backend',
    'basePath' => dirname(__DIR__),
    'controllerNamespace' => 'backend\controllers',
    'bootstrap' => ['log'],
    'aliases' => [
    ],
    'modules' => [
        'users' => [
            'class' => 'emberware\evidia\users\backend\Module',
        ],
        'options' => [
            'class' => 'emberware\evidia\options\backend\Module',
        ],
        'adminlte' => [
            'class' => 'emberware\evidia\adminlte\backend\Module',
        ],
        'permissions' => [
            'class' => 'emberware\evidia\permissions\backend\Module',
        ],
        'datecontrol' =>  [
            'class' => 'kartik\datecontrol\Module',
        ],
	'custom' => [
            'class' => 'bitcream\gmvricambi\custom\backend\Module',
        ],
        'files' => [
            'class' => 'floor12\files\Module',
            'storage' => '@app/storage',
            'cache' => '@app/storage_cache',
            'token_salt' => 'some_random_salt',
        ],
    ],
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-api',
            'enableCookieValidation' => false,
            'cookieValidationKey' => 'xxxx',
        ],
        'user' => [
            'identityClass' => 'emberware\evidia\users\common\models\User',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_identity-backend', 'httpOnly' => true],
        ],
        'session' => [
            // this is the name of the session cookie used for login on the backend
            'name' => 'advanced-backend',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'assetManager' => [
            'bundles' => [
                'dmstr\web\AdminLteAsset' => [
                    'skin' => 'skin-blue',
                ],
            ],
            'forceCopy' => YII_ENV_DEV ? true : false,
        ],
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                [
                    'pattern' => 'site/request-password-reset',
                    'route' => 'users/user/request-password-reset'
                ],
                [
                    'pattern' => 'site/reset-password',
                    'route' => 'users/user/reset-password'
                ],
                [
                    'pattern' => 'site/request-change-password',
                    'route' => 'users/user/request-change-password'
                ],
                [
                    'pattern' => 'site/change-password',
                    'route' => 'users/user/change-password'
                ],
                [
                    'pattern' => 'site/login',
                    'route' => 'adminlte/adminlte/login'
                ],
                [
                    'pattern' => 'site/logout',
                    'route' => 'adminlte/adminlte/logout'
                ],
            ],
        ],
        'view' => [
            'theme' => [
                'pathMap' => [
                    '@app/views' => [
                        //'@app/views/adminlte',
                        '@vendor/emberware/evidia-adminlte/backend/views/adminlte',
                    ],
                ],
            ],
        ], 
    ],
    'params' => $params,
];
