<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-console',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'controllerNamespace' => 'console\controllers',
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
        '@emberware/evidia/options' => '@vendor/emberware/evidia-options',
        '@emberware/evidia/users' => '@vendor/emberware/evidia-users',
        '@emberware/evidia/permissions' => '@vendor/emberware/evidia-permissions',
	'@bitcream/gmvricambi/custom' => '@vendor/bitcream/gmv-ricambi-custom',
    ],
    'modules' => [
        'options' => [
            'class' => 'emberware\evidia\options\console\Module',
        ],
        'users' => [
            'class' => 'emberware\evidia\users\console\Module',
        ],
        'permissions' => [
            'class' => 'emberware\evidia\permissions\console\Module',
        ],
	'custom' => [
    	    'class' => 'bitcream\gmvricambi\custom\console\Module',
	],
    ],
    'controllerMap' => [
        'fixture' => [
            'class' => 'yii\console\controllers\FixtureController',
            'namespace' => 'common\fixtures',
        ],
        'migrate' => [
            'class' => 'yii\console\controllers\MigrateController',
            'migrationPath' => [
                "@console/migrations",
                "@yii/rbac/migrations",
                "@vendor/emberware/evidia-users/commands/migrations",
                "@vendor/emberware/evidia-permissions/commands/migrations",
                "@vendor/emberware/evidia-options/commands/migrations",
		"@vendor/floor12/yii2-module-files/src/migrations",
            ],  
          'migrationNamespaces' => [
                'emberware\evidia\options\console\migrations',
                'emberware\evidia\permissions\console\migrations',
                'Kakadu\Yii2JwtAuth\migrations',
		'bitcream\gmvricambi\custom\console\migrations',
            ],
        ],
    ],
    'components' => [
        'log' => [
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
    ],
    'params' => $params,
];
