<?php
return [
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
	'@bitcream/gmvricambi/custom' => '@vendor/bitcream/gmv-ricambi-custom',
    ],
    'vendorPath' => dirname(dirname(__DIR__)) . '/vendor',
    'components' => [
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'authManager' => [
            'class' => 'yii\rbac\DbManager',
            // uncomment if you want to cache RBAC items hierarchy
            // 'cache' => 'cache',
        ],
        'apiTokens' => [
            'class'           => \Kakadu\Yii2JwtAuth\ApiTokenService::class,
            'secretKey'       => 'test1', // set in main-local.php or yii-params.domainSecretKey
            'issuer'          => 'you-domain-name', // or yii-params.domain
            'audience'        => ['you-domain-name', 'second-domain-name'], // or yii-params.domain
            'audienceSecrets' => [
                'you-domain-name'    => 'test1', // or yii-params.domainSecretKey
                'second-domain-name' => 'test2', // or yii-params.secondDomainSecretKey
            ],
            'seamlessLogin'   => true,
        ],
        'i18n' => [
            'translations' => [
                'gmv*' => [
                    'class' => 'yii\i18n\PhpMessageSource',
                    'basePath' => '@app/messages',
                    'sourceLanguage' => 'en-US',
                    'fileMap' => [
                        'gmv' => 'gmv.php',
                    ],
                ],
            ],
        ],
    ],
];
